/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: Elektrotechnikpraktikum.c
 *
 * Code generated for Simulink model 'Elektrotechnikpraktikum'.
 *
 * Model version                  : 1.5
 * Simulink Coder version         : 23.2 (R2023b) 01-Aug-2023
 * C/C++ source code generated on : Mon Jan 15 12:07:58 2024
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Elektrotechnikpraktikum.h"
#include "Elektrotechnikpraktikum_types.h"
#include <math.h>
#include "Elektrotechnikpraktikum_private.h"
#include "rtwtypes.h"
#include "rt_nonfinite.h"
#include <float.h>

/* Block signals (default storage) */
B_Elektrotechnikpraktikum_T Elektrotechnikpraktikum_B;

/* Continuous states */
X_Elektrotechnikpraktikum_T Elektrotechnikpraktikum_X;

/* Disabled State Vector */
XDis_Elektrotechnikpraktikum_T Elektrotechnikpraktikum_XDis;

/* Block states (default storage) */
DW_Elektrotechnikpraktikum_T Elektrotechnikpraktikum_DW;

/* Real-time model */
static RT_MODEL_Elektrotechnikprakti_T Elektrotechnikpraktikum_M_;
RT_MODEL_Elektrotechnikprakti_T *const Elektrotechnikpraktikum_M =
  &Elektrotechnikpraktikum_M_;

/* Forward declaration for local functions */
static void Elektrotechnik_SystemCore_setup(dsp_simulink_MovingAverage_El_T *obj);

/*
 * This function updates continuous states using the ODE8 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  /* Solver Matrices */
#define Elektrotechnikpraktikum_NSTAGES 13

  static real_T rt_ODE8_B[13] = {
    4.174749114153025E-2, 0.0, 0.0, 0.0,
    0.0, -5.54523286112393E-2, 2.393128072011801E-1, 7.03510669403443E-1,
    -7.597596138144609E-1, 6.605630309222863E-1, 1.581874825101233E-1,
    -2.381095387528628E-1, 2.5E-1
  };

  static real_T rt_ODE8_C[13] = {
    0.0, 5.555555555555556E-2, 8.333333333333333E-2, 1.25E-1,
    3.125E-1, 3.75E-1, 1.475E-1, 4.65E-1,
    5.648654513822596E-1, 6.5E-1, 9.246562776405044E-1, 1.0, 1.0
  };

  static real_T rt_ODE8_A[13][13] = {
    /* rt_ODE8_A[0][] */
    { 0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[1][] */
    { 5.555555555555556E-2, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[2][] */
    { 2.083333333333333E-2, 6.25E-2, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[3][] */
    { 3.125E-2, 0.0, 9.375E-2, 0.0,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[4][] */
    { 3.125E-1, 0.0, -1.171875, 1.171875,
      0.0, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[5][] */
    { 3.75E-2, 0.0, 0.0, 1.875E-1,
      1.5E-1, 0.0, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[6][] */
    { 4.791013711111111E-2, 0.0, 0.0, 1.122487127777778E-1,
      -2.550567377777778E-2, 1.284682388888889E-2, 0.0, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[7][] */
    { 1.691798978729228E-2, 0.0, 0.0, 3.878482784860432E-1,
      3.597736985150033E-2, 1.969702142156661E-1, -1.727138523405018E-1, 0.0,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[8][] */
    { 6.90957533591923E-2, 0.0, 0.0, -6.342479767288542E-1,
      -1.611975752246041E-1, 1.386503094588253E-1, 9.409286140357563E-1,
      2.11636326481944E-1,
      0.0, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[9][] */
    { 1.835569968390454E-1, 0.0, 0.0, -2.468768084315592,
      -2.912868878163005E-1, -2.647302023311738E-2, 2.8478387641928,
      2.813873314698498E-1,
      1.237448998633147E-1, 0.0, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[10][] */
    { -1.215424817395888, 0.0, 0.0, 1.667260866594577E1,
      9.157418284168179E-1, -6.056605804357471, -1.600357359415618E1,
      1.484930308629766E1,
      -1.337157573528985E1, 5.134182648179638, 0.0, 0.0, 0.0 },

    /* rt_ODE8_A[11][] */
    { 2.588609164382643E-1, 0.0, 0.0, -4.774485785489205,
      -4.350930137770325E-1, -3.049483332072241, 5.577920039936099,
      6.155831589861039,
      -5.062104586736938, 2.193926173180679, 1.346279986593349E-1, 0.0, 0.0 },

    /* rt_ODE8_A[12][] */
    { 8.224275996265075E-1, 0.0, 0.0, -1.165867325727766E1,
      -7.576221166909362E-1, 7.139735881595818E-1, 1.207577498689006E1,
      -2.127659113920403,
      1.990166207048956, -2.342864715440405E-1, 1.758985777079423E-1, 0.0, 0.0 },
  };

  time_T t = rtsiGetT(si);
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE8_IntgData *intgData = (ODE8_IntgData *)rtsiGetSolverData(si);
  real_T *deltaY = intgData->deltaY;
  real_T *x0 = intgData->x0;
  real_T* f[Elektrotechnikpraktikum_NSTAGES];
  int_T idx,stagesIdx,statesIdx;
  real_T deltaX;
  int_T nXc = 4;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);
  f[0] = intgData->f[0];
  f[1] = intgData->f[1];
  f[2] = intgData->f[2];
  f[3] = intgData->f[3];
  f[4] = intgData->f[4];
  f[5] = intgData->f[5];
  f[6] = intgData->f[6];
  f[7] = intgData->f[7];
  f[8] = intgData->f[8];
  f[9] = intgData->f[9];
  f[10] = intgData->f[10];
  f[11] = intgData->f[11];
  f[12] = intgData->f[12];

  /* Save the state values at time t in y and x0*/
  (void) memset(deltaY, 0,
                (uint_T)nXc*sizeof(real_T));
  (void) memcpy(x0, x,
                nXc*sizeof(real_T));
  for (stagesIdx=0;stagesIdx<Elektrotechnikpraktikum_NSTAGES;stagesIdx++) {
    (void) memcpy(x, x0,
                  (uint_T)nXc*sizeof(real_T));
    for (statesIdx=0;statesIdx<nXc;statesIdx++) {
      deltaX = 0;
      for (idx=0;idx<stagesIdx;idx++) {
        deltaX = deltaX + h*rt_ODE8_A[stagesIdx][idx]*f[idx][statesIdx];
      }

      x[statesIdx] = x0[statesIdx] + deltaX;
    }

    if (stagesIdx==0) {
      rtsiSetdX(si, f[stagesIdx]);
      Elektrotechnikpraktikum_derivatives();
    } else {
      (stagesIdx==Elektrotechnikpraktikum_NSTAGES-1)? rtsiSetT(si, tnew) :
        rtsiSetT(si, t + h*rt_ODE8_C[stagesIdx]);
      rtsiSetdX(si, f[stagesIdx]);
      Elektrotechnikpraktikum_step();
      Elektrotechnikpraktikum_derivatives();
    }

    for (statesIdx=0;statesIdx<nXc;statesIdx++) {
      deltaY[statesIdx] = deltaY[statesIdx] + h*rt_ODE8_B[stagesIdx]*f[stagesIdx]
        [statesIdx];
    }
  }

  for (statesIdx=0;statesIdx<nXc;statesIdx++) {
    x[statesIdx] = x0[statesIdx] + deltaY[statesIdx];
  }

  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

real_T rt_modd_snf(real_T u0, real_T u1)
{
  real_T q;
  real_T y;
  boolean_T yEq;
  y = u0;
  if (u1 == 0.0) {
    if (u0 == 0.0) {
      y = u1;
    }
  } else if (rtIsNaN(u0) || rtIsNaN(u1) || rtIsInf(u0)) {
    y = (rtNaN);
  } else if (u0 == 0.0) {
    y = 0.0 / u1;
  } else if (rtIsInf(u1)) {
    if ((u1 < 0.0) != (u0 < 0.0)) {
      y = u1;
    }
  } else {
    y = fmod(u0, u1);
    yEq = (y == 0.0);
    if ((!yEq) && (u1 > floor(u1))) {
      q = fabs(u0 / u1);
      yEq = !(fabs(q - floor(q + 0.5)) > DBL_EPSILON * q);
    }

    if (yEq) {
      y = u1 * 0.0;
    } else if ((u0 < 0.0) != (u1 < 0.0)) {
      y += u1;
    }
  }

  return y;
}

real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

static void Elektrotechnik_SystemCore_setup(dsp_simulink_MovingAverage_El_T *obj)
{
  obj->isSetupComplete = false;
  obj->isInitialized = 1L;

  /* Start for MATLABSystem: '<Root>/Moving Average' */
  obj->NumChannels = 1L;
  obj->FrameLength = 1L;
  obj->_pobj0.isInitialized = 0L;
  obj->_pobj0.isInitialized = 0L;
  obj->pStatistic = &obj->_pobj0;
  obj->isSetupComplete = true;
  obj->TunablePropsChanged = false;
}

/* Model step function */
void Elektrotechnikpraktikum_step(void)
{
  if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&Elektrotechnikpraktikum_M->solverInfo,
                          ((Elektrotechnikpraktikum_M->Timing.clockTick0+1)*
      Elektrotechnikpraktikum_M->Timing.stepSize0));
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Elektrotechnikpraktikum_M)) {
    Elektrotechnikpraktikum_M->Timing.t[0] = rtsiGetT
      (&Elektrotechnikpraktikum_M->solverInfo);
  }

  {
    h_dsp_internal_SlidingWindowA_T *obj;
    real_T csum;
    real_T cumRevIndex;
    real_T modValueRev;
    real_T rtb_Add1;
    real_T z;
    uint16_T b_varargout_1;
    uint8_T tmp;

    /* MATLABSystem: '<Root>/Analog Input1' */
    if (Elektrotechnikpraktikum_DW.obj_g.SampleTime !=
        Elektrotechnikpraktikum_P.AnalogInput1_SampleTime) {
      Elektrotechnikpraktikum_DW.obj_g.SampleTime =
        Elektrotechnikpraktikum_P.AnalogInput1_SampleTime;
    }

    Elektrotechnikpraktikum_DW.obj_g.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogIn_GetHandle(54UL);
    MW_AnalogInSingle_ReadResult
      (Elektrotechnikpraktikum_DW.obj_g.AnalogInDriverObj.MW_ANALOGIN_HANDLE,
       &b_varargout_1, MW_ANALOGIN_UINT16);

    /* Gain: '<Root>/Multiply2' incorporates:
     *  Constant: '<Root>/Constant'
     *  MATLABSystem: '<Root>/Analog Input1'
     *  Product: '<Root>/Divide5'
     * */
    Elektrotechnikpraktikum_B.Multiply2 = (real_T)b_varargout_1 /
      Elektrotechnikpraktikum_P.Constant_Value *
      Elektrotechnikpraktikum_P.Multiply2_Gain;
    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
    }

    /* MATLABSystem: '<Root>/Digital Input2' */
    if (Elektrotechnikpraktikum_DW.obj_d.SampleTime !=
        Elektrotechnikpraktikum_P.DigitalInput2_SampleTime) {
      Elektrotechnikpraktikum_DW.obj_d.SampleTime =
        Elektrotechnikpraktikum_P.DigitalInput2_SampleTime;
    }

    /* MATLABSystem: '<Root>/Digital Input2' */
    Elektrotechnikpraktikum_B.u = readDigitalPin(3);
    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
      /* UnitDelay: '<S1>/Delay Input1'
       *
       * Block description for '<S1>/Delay Input1':
       *
       *  Store in Global RAM
       */
      Elektrotechnikpraktikum_B.Uk1 =
        Elektrotechnikpraktikum_DW.DelayInput1_DSTATE;

      /* Delay: '<Root>/Delay' */
      Elektrotechnikpraktikum_B.Delay = Elektrotechnikpraktikum_DW.Delay_DSTATE;

      /* Delay: '<Root>/Delay1' */
      Elektrotechnikpraktikum_B.Delay1 =
        Elektrotechnikpraktikum_DW.Delay1_DSTATE[0];
    }

    /* Sum: '<Root>/Add' incorporates:
     *  DataTypeConversion: '<Root>/Data Type Conversion'
     *  RelationalOperator: '<S1>/FixPt Relational Operator'
     */
    Elektrotechnikpraktikum_B.Add = (real_T)((int16_T)
      Elektrotechnikpraktikum_B.u > (int16_T)Elektrotechnikpraktikum_B.Uk1) +
      Elektrotechnikpraktikum_B.Delay;

    /* Sum: '<Root>/Add1' */
    rtb_Add1 = Elektrotechnikpraktikum_B.Add - Elektrotechnikpraktikum_B.Delay1;

    /* MATLABSystem: '<Root>/Moving Average' */
    if (Elektrotechnikpraktikum_DW.obj.TunablePropsChanged) {
      Elektrotechnikpraktikum_DW.obj.TunablePropsChanged = false;
    }

    obj = Elektrotechnikpraktikum_DW.obj.pStatistic;
    if (Elektrotechnikpraktikum_DW.obj.pStatistic->isInitialized != 1L) {
      Elektrotechnikpraktikum_DW.obj.pStatistic->isSetupComplete = false;
      Elektrotechnikpraktikum_DW.obj.pStatistic->isInitialized = 1L;
      obj->pCumSum = 0.0;
      obj->pCumRevIndex = 1.0;
      obj->pModValueRev = 0.0;
      obj->isSetupComplete = true;
      obj->pCumSum = 0.0;
      obj->pCumSumRev[0] = 0.0;
      obj->pCumSumRev[0] = 0.0;
      obj->pCumSumRev[1] = 0.0;
      obj->pCumSumRev[1] = 0.0;
      obj->pCumSumRev[2] = 0.0;
      obj->pCumSumRev[2] = 0.0;
      obj->pCumRevIndex = 1.0;
      obj->pModValueRev = 0.0;
    }

    cumRevIndex = obj->pCumRevIndex;
    csum = obj->pCumSum;
    Elektrotechnikpraktikum_B.csumrev[0] = obj->pCumSumRev[0];
    Elektrotechnikpraktikum_B.csumrev[1] = obj->pCumSumRev[1];
    Elektrotechnikpraktikum_B.csumrev[2] = obj->pCumSumRev[2];
    modValueRev = obj->pModValueRev;
    z = 0.0;

    /* MATLABSystem: '<Root>/Moving Average' */
    Elektrotechnikpraktikum_B.MovingAverage = 0.0;

    /* MATLABSystem: '<Root>/Moving Average' */
    csum += rtb_Add1;
    if (modValueRev == 0.0) {
      z = Elektrotechnikpraktikum_B.csumrev[(int16_T)cumRevIndex - 1] + csum;
    }

    Elektrotechnikpraktikum_B.csumrev[(int16_T)cumRevIndex - 1] = rtb_Add1;
    if (cumRevIndex != 3.0) {
      cumRevIndex++;
    } else {
      cumRevIndex = 1.0;
      csum = 0.0;
      Elektrotechnikpraktikum_B.csumrev[1] += Elektrotechnikpraktikum_B.csumrev
        [2];
      Elektrotechnikpraktikum_B.csumrev[0] += Elektrotechnikpraktikum_B.csumrev
        [1];
    }

    if (modValueRev == 0.0) {
      /* MATLABSystem: '<Root>/Moving Average' */
      Elektrotechnikpraktikum_B.MovingAverage = z / 4.0;
    }

    obj->pCumSum = csum;
    obj->pCumSumRev[0] = Elektrotechnikpraktikum_B.csumrev[0];
    obj->pCumSumRev[1] = Elektrotechnikpraktikum_B.csumrev[1];
    obj->pCumSumRev[2] = Elektrotechnikpraktikum_B.csumrev[2];
    obj->pCumRevIndex = cumRevIndex;
    if (modValueRev > 0.0) {
      obj->pModValueRev = modValueRev - 1.0;
    } else {
      obj->pModValueRev = 0.0;
    }

    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
      /* Product: '<Root>/Product' incorporates:
       *  Constant: '<Root>/Constant2'
       *  Constant: '<Root>/Constant3'
       */
      Elektrotechnikpraktikum_B.Product =
        Elektrotechnikpraktikum_P.Constant2_Value *
        Elektrotechnikpraktikum_P.Constant3_Value;

      /* Gain: '<S2>/Slider Gain' incorporates:
       *  Constant: '<Root>/Constant5'
       */
      Elektrotechnikpraktikum_B.SliderGain =
        Elektrotechnikpraktikum_P.KalibrierBaustein_gain *
        Elektrotechnikpraktikum_P.Constant5_Value;
    }

    /* Product: '<Root>/Product2' incorporates:
     *  Constant: '<Root>/Constant4'
     *  Constant: '<Root>/Constant6'
     *  Product: '<Root>/Divide1'
     *  Product: '<Root>/Divide2'
     *  Product: '<Root>/Product1'
     */
    Elektrotechnikpraktikum_B.Product2 = Elektrotechnikpraktikum_B.MovingAverage
      / Elektrotechnikpraktikum_B.Product *
      Elektrotechnikpraktikum_P.Constant4_Value /
      Elektrotechnikpraktikum_B.SliderGain *
      Elektrotechnikpraktikum_P.Constant6_Value;

    /* Sum: '<Root>/Sum' incorporates:
     *  Abs: '<Root>/Abs'
     */
    Elektrotechnikpraktikum_B.Sum = Elektrotechnikpraktikum_B.Multiply2 - fabs
      (Elektrotechnikpraktikum_B.Product2);

    /* Sum: '<Root>/Sum1' incorporates:
     *  Gain: '<Root>/Gain2'
     *  Integrator: '<Root>/Integrator2'
     */
    Elektrotechnikpraktikum_B.Saturation = Elektrotechnikpraktikum_P.Gain2_Gain *
      Elektrotechnikpraktikum_B.Sum +
      Elektrotechnikpraktikum_X.Integrator2_CSTATE;

    /* Saturate: '<Root>/Saturation' */
    if (Elektrotechnikpraktikum_B.Saturation >
        Elektrotechnikpraktikum_P.Saturation_UpperSat) {
      /* Sum: '<Root>/Sum1' incorporates:
       *  Saturate: '<Root>/Saturation'
       */
      Elektrotechnikpraktikum_B.Saturation =
        Elektrotechnikpraktikum_P.Saturation_UpperSat;
    } else if (Elektrotechnikpraktikum_B.Saturation <
               Elektrotechnikpraktikum_P.Saturation_LowerSat) {
      /* Sum: '<Root>/Sum1' incorporates:
       *  Saturate: '<Root>/Saturation'
       */
      Elektrotechnikpraktikum_B.Saturation =
        Elektrotechnikpraktikum_P.Saturation_LowerSat;
    }

    /* End of Saturate: '<Root>/Saturation' */

    /* Gain: '<Root>/Multiply1' incorporates:
     *  Constant: '<Root>/Constant7'
     *  Product: '<Root>/Divide3'
     */
    Elektrotechnikpraktikum_B.Multiply1 = Elektrotechnikpraktikum_B.Saturation /
      Elektrotechnikpraktikum_P.Constant7_Value *
      Elektrotechnikpraktikum_P.Multiply1_Gain;

    /* Product: '<Root>/Product3' incorporates:
     *  Constant: '<Root>/Constant12'
     *  RelationalOperator: '<Root>/Relational Operator'
     */
    Elektrotechnikpraktikum_B.Product3 = (real_T)
      (Elektrotechnikpraktikum_B.Multiply1 >=
       Elektrotechnikpraktikum_P.Constant12_Value) *
      Elektrotechnikpraktikum_B.Multiply1;

    /* MATLABSystem: '<Root>/Motor' */
    Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE =
      MW_PWM_GetHandle(11UL);

    /* Start for MATLABSystem: '<Root>/Motor' */
    if (Elektrotechnikpraktikum_B.Product3 <= 255.0) {
      rtb_Add1 = Elektrotechnikpraktikum_B.Product3;
    } else {
      rtb_Add1 = 255.0;
    }

    if (!(rtb_Add1 >= 0.0)) {
      rtb_Add1 = 0.0;
    }

    /* MATLABSystem: '<Root>/Motor' */
    MW_PWM_SetDutyCycle
      (Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE, rtb_Add1);
    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
    }

    /* Math: '<Root>/Mod1' incorporates:
     *  Constant: '<Root>/Constant13'
     *  Integrator: '<Root>/Integrator1'
     */
    Elektrotechnikpraktikum_B.Mod1 = rt_modd_snf
      (Elektrotechnikpraktikum_X.Integrator1_CSTATE,
       Elektrotechnikpraktikum_P.Constant13_Value);
    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
      /* ManualSwitch: '<Root>/Manual Switch' incorporates:
       *  Constant: '<Root>/Constant10'
       *  Constant: '<Root>/Constant8'
       */
      if (Elektrotechnikpraktikum_P.ManualSwitch_CurrentSetting == 1) {
        rtb_Add1 = Elektrotechnikpraktikum_P.Constant8_Value;
      } else {
        rtb_Add1 = Elektrotechnikpraktikum_P.Constant10_Value;
      }

      /* MATLABSystem: '<Root>/Digital Output1' incorporates:
       *  ManualSwitch: '<Root>/Manual Switch'
       */
      rtb_Add1 = rt_roundd_snf(rtb_Add1);
      if (rtb_Add1 < 256.0) {
        if (rtb_Add1 >= 0.0) {
          tmp = (uint8_T)rtb_Add1;
        } else {
          tmp = 0U;
        }
      } else {
        tmp = MAX_uint8_T;
      }

      writeDigitalPin(10, tmp);

      /* End of MATLABSystem: '<Root>/Digital Output1' */

      /* ManualSwitch: '<Root>/Manual Switch1' incorporates:
       *  Constant: '<Root>/Constant11'
       *  Constant: '<Root>/Constant9'
       */
      if (Elektrotechnikpraktikum_P.ManualSwitch1_CurrentSetting == 1) {
        rtb_Add1 = Elektrotechnikpraktikum_P.Constant9_Value;
      } else {
        rtb_Add1 = Elektrotechnikpraktikum_P.Constant11_Value;
      }

      /* MATLABSystem: '<Root>/Digital Output2' incorporates:
       *  ManualSwitch: '<Root>/Manual Switch1'
       */
      rtb_Add1 = rt_roundd_snf(rtb_Add1);
      if (rtb_Add1 < 256.0) {
        if (rtb_Add1 >= 0.0) {
          tmp = (uint8_T)rtb_Add1;
        } else {
          tmp = 0U;
        }
      } else {
        tmp = MAX_uint8_T;
      }

      writeDigitalPin(9, tmp);

      /* End of MATLABSystem: '<Root>/Digital Output2' */
    }
  }

  if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
    int16_T idxDelay;
    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
      /* Update for UnitDelay: '<S1>/Delay Input1'
       *
       * Block description for '<S1>/Delay Input1':
       *
       *  Store in Global RAM
       */
      Elektrotechnikpraktikum_DW.DelayInput1_DSTATE =
        Elektrotechnikpraktikum_B.u;

      /* Update for Delay: '<Root>/Delay' */
      Elektrotechnikpraktikum_DW.Delay_DSTATE = Elektrotechnikpraktikum_B.Add;

      /* Update for Delay: '<Root>/Delay1' */
      for (idxDelay = 0; idxDelay < 99; idxDelay++) {
        Elektrotechnikpraktikum_DW.Delay1_DSTATE[idxDelay] =
          Elektrotechnikpraktikum_DW.Delay1_DSTATE[idxDelay + 1];
      }

      Elektrotechnikpraktikum_DW.Delay1_DSTATE[99] =
        Elektrotechnikpraktikum_B.Add;

      /* End of Update for Delay: '<Root>/Delay1' */
    }

    {                                  /* Sample time: [0.0s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Elektrotechnikpraktikum_M->Timing.clockTick0 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(0,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }

    if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {/* Sample time: [0.0005s, 0.0s] */
      extmodeErrorCode_T errorCode = EXTMODE_SUCCESS;
      extmodeSimulationTime_T currentTime = (extmodeSimulationTime_T)
        ((Elektrotechnikpraktikum_M->Timing.clockTick1 * 1) + 0)
        ;

      /* Trigger External Mode event */
      errorCode = extmodeEvent(1,currentTime);
      if (errorCode != EXTMODE_SUCCESS) {
        /* Code to handle External Mode event errors
           may be added here */
      }
    }
  }                                    /* end MajorTimeStep */

  if (rtmIsMajorTimeStep(Elektrotechnikpraktikum_M)) {
    rt_ertODEUpdateContinuousStates(&Elektrotechnikpraktikum_M->solverInfo);

    /* Update absolute time for base rate */
    /* The "clockTick0" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick0"
     * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
     * overflow during the application lifespan selected.
     */
    ++Elektrotechnikpraktikum_M->Timing.clockTick0;
    Elektrotechnikpraktikum_M->Timing.t[0] = rtsiGetSolverStopTime
      (&Elektrotechnikpraktikum_M->solverInfo);

    {
      /* Update absolute timer for sample time: [0.0005s, 0.0s] */
      /* The "clockTick1" counts the number of times the code of this task has
       * been executed. The resolution of this integer timer is 0.0005, which is the step size
       * of the task. Size of "clockTick1" ensures timer will not overflow during the
       * application lifespan selected.
       */
      Elektrotechnikpraktikum_M->Timing.clockTick1++;
    }
  }                                    /* end MajorTimeStep */
}

/* Derivatives for root system: '<Root>' */
void Elektrotechnikpraktikum_derivatives(void)
{
  XDot_Elektrotechnikpraktikum_T *_rtXdot;
  _rtXdot = ((XDot_Elektrotechnikpraktikum_T *)
             Elektrotechnikpraktikum_M->derivs);

  /* Derivatives for Integrator: '<Root>/Integrator2' */
  _rtXdot->Integrator2_CSTATE = Elektrotechnikpraktikum_B.Sum;

  /* Derivatives for Integrator: '<Root>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = Elektrotechnikpraktikum_B.Product2;

  /* Derivatives for Integrator: '<Root>/Integrator3' */
  _rtXdot->Integrator3_CSTATE = 0.0;

  /* Derivatives for TransferFcn: '<Root>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE = Elektrotechnikpraktikum_P.TransferFcn1_A *
    Elektrotechnikpraktikum_X.TransferFcn1_CSTATE;
}

/* Model initialize function */
void Elektrotechnikpraktikum_initialize(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Elektrotechnikpraktikum_M->solverInfo,
                          &Elektrotechnikpraktikum_M->Timing.simTimeStep);
    rtsiSetTPtr(&Elektrotechnikpraktikum_M->solverInfo, &rtmGetTPtr
                (Elektrotechnikpraktikum_M));
    rtsiSetStepSizePtr(&Elektrotechnikpraktikum_M->solverInfo,
                       &Elektrotechnikpraktikum_M->Timing.stepSize0);
    rtsiSetdXPtr(&Elektrotechnikpraktikum_M->solverInfo,
                 &Elektrotechnikpraktikum_M->derivs);
    rtsiSetContStatesPtr(&Elektrotechnikpraktikum_M->solverInfo, (real_T **)
                         &Elektrotechnikpraktikum_M->contStates);
    rtsiSetNumContStatesPtr(&Elektrotechnikpraktikum_M->solverInfo,
      &Elektrotechnikpraktikum_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&Elektrotechnikpraktikum_M->solverInfo,
      &Elektrotechnikpraktikum_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&Elektrotechnikpraktikum_M->solverInfo,
      &Elektrotechnikpraktikum_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&Elektrotechnikpraktikum_M->solverInfo,
      &Elektrotechnikpraktikum_M->periodicContStateRanges);
    rtsiSetContStateDisabledPtr(&Elektrotechnikpraktikum_M->solverInfo,
      (boolean_T**) &Elektrotechnikpraktikum_M->contStateDisabled);
    rtsiSetErrorStatusPtr(&Elektrotechnikpraktikum_M->solverInfo,
                          (&rtmGetErrorStatus(Elektrotechnikpraktikum_M)));
    rtsiSetRTModelPtr(&Elektrotechnikpraktikum_M->solverInfo,
                      Elektrotechnikpraktikum_M);
  }

  rtsiSetSimTimeStep(&Elektrotechnikpraktikum_M->solverInfo, MAJOR_TIME_STEP);
  Elektrotechnikpraktikum_M->intgData.deltaY=
    Elektrotechnikpraktikum_M->OdeDeltaY;
  Elektrotechnikpraktikum_M->intgData.f[0] = Elektrotechnikpraktikum_M->odeF[0];
  Elektrotechnikpraktikum_M->intgData.f[1] = Elektrotechnikpraktikum_M->odeF[1];
  Elektrotechnikpraktikum_M->intgData.f[2] = Elektrotechnikpraktikum_M->odeF[2];
  Elektrotechnikpraktikum_M->intgData.f[3] = Elektrotechnikpraktikum_M->odeF[3];
  Elektrotechnikpraktikum_M->intgData.f[4] = Elektrotechnikpraktikum_M->odeF[4];
  Elektrotechnikpraktikum_M->intgData.f[5] = Elektrotechnikpraktikum_M->odeF[5];
  Elektrotechnikpraktikum_M->intgData.f[6] = Elektrotechnikpraktikum_M->odeF[6];
  Elektrotechnikpraktikum_M->intgData.f[7] = Elektrotechnikpraktikum_M->odeF[7];
  Elektrotechnikpraktikum_M->intgData.f[8] = Elektrotechnikpraktikum_M->odeF[8];
  Elektrotechnikpraktikum_M->intgData.f[9] = Elektrotechnikpraktikum_M->odeF[9];
  Elektrotechnikpraktikum_M->intgData.f[10] = Elektrotechnikpraktikum_M->odeF[10];
  Elektrotechnikpraktikum_M->intgData.f[11] = Elektrotechnikpraktikum_M->odeF[11];
  Elektrotechnikpraktikum_M->intgData.f[12] = Elektrotechnikpraktikum_M->odeF[12];
  Elektrotechnikpraktikum_M->intgData.x0 = Elektrotechnikpraktikum_M->odeX0;
  Elektrotechnikpraktikum_M->contStates = ((X_Elektrotechnikpraktikum_T *)
    &Elektrotechnikpraktikum_X);
  Elektrotechnikpraktikum_M->contStateDisabled =
    ((XDis_Elektrotechnikpraktikum_T *) &Elektrotechnikpraktikum_XDis);
  Elektrotechnikpraktikum_M->Timing.tStart = (0.0);
  rtsiSetSolverData(&Elektrotechnikpraktikum_M->solverInfo, (void *)
                    &Elektrotechnikpraktikum_M->intgData);
  rtsiSetIsMinorTimeStepWithModeChange(&Elektrotechnikpraktikum_M->solverInfo,
    false);
  rtsiSetSolverName(&Elektrotechnikpraktikum_M->solverInfo,"ode8");
  rtmSetTPtr(Elektrotechnikpraktikum_M,
             &Elektrotechnikpraktikum_M->Timing.tArray[0]);
  rtmSetTFinal(Elektrotechnikpraktikum_M, -1);
  Elektrotechnikpraktikum_M->Timing.stepSize0 = 0.0005;

  /* External mode info */
  Elektrotechnikpraktikum_M->Sizes.checksums[0] = (1662954992U);
  Elektrotechnikpraktikum_M->Sizes.checksums[1] = (1864416168U);
  Elektrotechnikpraktikum_M->Sizes.checksums[2] = (2941616672U);
  Elektrotechnikpraktikum_M->Sizes.checksums[3] = (1384272939U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[11];
    Elektrotechnikpraktikum_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = &rtAlwaysEnabled;
    systemRan[4] = &rtAlwaysEnabled;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    systemRan[8] = &rtAlwaysEnabled;
    systemRan[9] = &rtAlwaysEnabled;
    systemRan[10] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(Elektrotechnikpraktikum_M->extModeInfo,
      &Elektrotechnikpraktikum_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(Elektrotechnikpraktikum_M->extModeInfo,
                        Elektrotechnikpraktikum_M->Sizes.checksums);
    rteiSetTPtr(Elektrotechnikpraktikum_M->extModeInfo, rtmGetTPtr
                (Elektrotechnikpraktikum_M));
  }

  {
    h_dsp_internal_SlidingWindowA_T *obj;
    int16_T i;

    /* InitializeConditions for UnitDelay: '<S1>/Delay Input1'
     *
     * Block description for '<S1>/Delay Input1':
     *
     *  Store in Global RAM
     */
    Elektrotechnikpraktikum_DW.DelayInput1_DSTATE =
      Elektrotechnikpraktikum_P.DetectIncrease_vinit;

    /* InitializeConditions for Delay: '<Root>/Delay' */
    Elektrotechnikpraktikum_DW.Delay_DSTATE =
      Elektrotechnikpraktikum_P.Delay_InitialCondition;

    /* InitializeConditions for Delay: '<Root>/Delay1' */
    for (i = 0; i < 100; i++) {
      Elektrotechnikpraktikum_DW.Delay1_DSTATE[i] =
        Elektrotechnikpraktikum_P.Delay1_InitialCondition;
    }

    /* End of InitializeConditions for Delay: '<Root>/Delay1' */

    /* InitializeConditions for Integrator: '<Root>/Integrator2' */
    Elektrotechnikpraktikum_X.Integrator2_CSTATE =
      Elektrotechnikpraktikum_P.Integrator2_IC;

    /* InitializeConditions for Integrator: '<Root>/Integrator1' */
    Elektrotechnikpraktikum_X.Integrator1_CSTATE =
      Elektrotechnikpraktikum_P.Integrator1_IC;

    /* InitializeConditions for Integrator: '<Root>/Integrator3' */
    Elektrotechnikpraktikum_X.Integrator3_CSTATE =
      Elektrotechnikpraktikum_P.Integrator3_IC;

    /* InitializeConditions for TransferFcn: '<Root>/Transfer Fcn1' */
    Elektrotechnikpraktikum_X.TransferFcn1_CSTATE = 0.0;

    /* Start for MATLABSystem: '<Root>/Analog Input1' */
    Elektrotechnikpraktikum_DW.obj_g.matlabCodegenIsDeleted = false;
    Elektrotechnikpraktikum_DW.obj_g.SampleTime =
      Elektrotechnikpraktikum_P.AnalogInput1_SampleTime;
    Elektrotechnikpraktikum_DW.obj_g.isInitialized = 1L;
    Elektrotechnikpraktikum_DW.obj_g.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
      MW_AnalogInSingle_Open(54UL);
    Elektrotechnikpraktikum_DW.obj_g.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Digital Input2' */
    Elektrotechnikpraktikum_DW.obj_d.matlabCodegenIsDeleted = false;
    Elektrotechnikpraktikum_DW.obj_d.SampleTime =
      Elektrotechnikpraktikum_P.DigitalInput2_SampleTime;
    Elektrotechnikpraktikum_DW.obj_d.isInitialized = 1L;
    digitalIOSetup(3, 0);
    Elektrotechnikpraktikum_DW.obj_d.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Moving Average' */
    Elektrotechnikpraktikum_DW.obj.isInitialized = 0L;
    Elektrotechnikpraktikum_DW.obj.NumChannels = -1L;
    Elektrotechnikpraktikum_DW.obj.FrameLength = -1L;
    Elektrotechnikpraktikum_DW.obj.matlabCodegenIsDeleted = false;
    Elektrotechnik_SystemCore_setup(&Elektrotechnikpraktikum_DW.obj);

    /* InitializeConditions for MATLABSystem: '<Root>/Moving Average' */
    obj = Elektrotechnikpraktikum_DW.obj.pStatistic;
    if (obj->isInitialized == 1L) {
      obj->pCumSum = 0.0;
      obj->pCumSumRev[0] = 0.0;
      obj->pCumSumRev[1] = 0.0;
      obj->pCumSumRev[2] = 0.0;
      obj->pCumRevIndex = 1.0;
      obj->pModValueRev = 0.0;
    }

    /* End of InitializeConditions for MATLABSystem: '<Root>/Moving Average' */

    /* Start for MATLABSystem: '<Root>/Motor' */
    Elektrotechnikpraktikum_DW.obj_n.matlabCodegenIsDeleted = false;
    Elektrotechnikpraktikum_DW.obj_n.isInitialized = 1L;
    Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open
      (11UL, 0.0, 0.0);
    Elektrotechnikpraktikum_DW.obj_n.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Digital Output1' */
    Elektrotechnikpraktikum_DW.obj_ac.matlabCodegenIsDeleted = false;
    Elektrotechnikpraktikum_DW.obj_ac.isInitialized = 1L;
    digitalIOSetup(10, 1);
    Elektrotechnikpraktikum_DW.obj_ac.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Digital Output2' */
    Elektrotechnikpraktikum_DW.obj_a.matlabCodegenIsDeleted = false;
    Elektrotechnikpraktikum_DW.obj_a.isInitialized = 1L;
    digitalIOSetup(9, 1);
    Elektrotechnikpraktikum_DW.obj_a.isSetupComplete = true;
  }
}

/* Model terminate function */
void Elektrotechnikpraktikum_terminate(void)
{
  h_dsp_internal_SlidingWindowA_T *obj;

  /* Terminate for MATLABSystem: '<Root>/Analog Input1' */
  if (!Elektrotechnikpraktikum_DW.obj_g.matlabCodegenIsDeleted) {
    Elektrotechnikpraktikum_DW.obj_g.matlabCodegenIsDeleted = true;
    if ((Elektrotechnikpraktikum_DW.obj_g.isInitialized == 1L) &&
        Elektrotechnikpraktikum_DW.obj_g.isSetupComplete) {
      Elektrotechnikpraktikum_DW.obj_g.AnalogInDriverObj.MW_ANALOGIN_HANDLE =
        MW_AnalogIn_GetHandle(54UL);
      MW_AnalogIn_Close
        (Elektrotechnikpraktikum_DW.obj_g.AnalogInDriverObj.MW_ANALOGIN_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Analog Input1' */
  /* Terminate for MATLABSystem: '<Root>/Digital Input2' */
  if (!Elektrotechnikpraktikum_DW.obj_d.matlabCodegenIsDeleted) {
    Elektrotechnikpraktikum_DW.obj_d.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Digital Input2' */

  /* Terminate for MATLABSystem: '<Root>/Moving Average' */
  if (!Elektrotechnikpraktikum_DW.obj.matlabCodegenIsDeleted) {
    Elektrotechnikpraktikum_DW.obj.matlabCodegenIsDeleted = true;
    if ((Elektrotechnikpraktikum_DW.obj.isInitialized == 1L) &&
        Elektrotechnikpraktikum_DW.obj.isSetupComplete) {
      obj = Elektrotechnikpraktikum_DW.obj.pStatistic;
      if (obj->isInitialized == 1L) {
        obj->isInitialized = 2L;
      }

      Elektrotechnikpraktikum_DW.obj.NumChannels = -1L;
      Elektrotechnikpraktikum_DW.obj.FrameLength = -1L;
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Moving Average' */

  /* Terminate for MATLABSystem: '<Root>/Motor' */
  if (!Elektrotechnikpraktikum_DW.obj_n.matlabCodegenIsDeleted) {
    Elektrotechnikpraktikum_DW.obj_n.matlabCodegenIsDeleted = true;
    if ((Elektrotechnikpraktikum_DW.obj_n.isInitialized == 1L) &&
        Elektrotechnikpraktikum_DW.obj_n.isSetupComplete) {
      Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(11UL);
      MW_PWM_SetDutyCycle
        (Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE =
        MW_PWM_GetHandle(11UL);
      MW_PWM_Close(Elektrotechnikpraktikum_DW.obj_n.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Motor' */
  /* Terminate for MATLABSystem: '<Root>/Digital Output1' */
  if (!Elektrotechnikpraktikum_DW.obj_ac.matlabCodegenIsDeleted) {
    Elektrotechnikpraktikum_DW.obj_ac.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Digital Output1' */

  /* Terminate for MATLABSystem: '<Root>/Digital Output2' */
  if (!Elektrotechnikpraktikum_DW.obj_a.matlabCodegenIsDeleted) {
    Elektrotechnikpraktikum_DW.obj_a.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Digital Output2' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
